# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.

## Our Standards

### Positive Behaviors

Examples of behavior that contributes to a positive environment:

- **Be welcoming** - Use inclusive language and welcome newcomers
- **Be respectful** - Respect differing viewpoints and experiences
- **Be constructive** - Provide helpful feedback focused on improvement
- **Be collaborative** - Work together toward common goals
- **Be patient** - Remember that everyone was once a beginner
- **Be gracious** - Accept constructive criticism gracefully
- **Show empathy** - Try to understand others' perspectives

### Unacceptable Behaviors

Examples of unacceptable behavior:

- Harassment, intimidation, or discrimination in any form
- Trolling, insulting/derogatory comments, and personal attacks
- Public or private harassment
- Publishing others' private information without permission
- Sexual language, imagery, or unwelcome advances
- Sustained disruption of discussions or events
- Other conduct inappropriate in a professional setting

## Scope

This Code of Conduct applies within all community spaces, including:

- GitHub repositories (issues, pull requests, discussions, code reviews)
- Community chat channels
- Mailing lists and forums
- Social media interactions related to the project
- In-person or virtual events

It also applies when representing the project in public spaces.

## Enforcement

### Reporting

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the project maintainers through:

1. **GitHub** - Contact repository maintainers directly
2. **Private message** - Reach out to maintainers privately

All complaints will be reviewed and investigated promptly and fairly. Privacy and security of the reporter will be respected.

### Enforcement Guidelines

Community leaders will follow these guidelines in determining consequences:

#### 1. Correction

**Community Impact**: Minor inappropriate behavior

**Consequence**: Private written warning with explanation of why the behavior was inappropriate. A public apology may be requested.

#### 2. Warning

**Community Impact**: Violation through a single incident or series of actions

**Consequence**: Warning with consequences for continued behavior. No interaction with involved parties for a specified period. Violating these terms may lead to a temporary or permanent ban.

#### 3. Temporary Ban

**Community Impact**: Serious violation or sustained inappropriate behavior

**Consequence**: Temporary ban from community interaction for a specified period. No public or private interaction with involved parties. Violating these terms may lead to a permanent ban.

#### 4. Permanent Ban

**Community Impact**: Pattern of violations, harassment, or aggression

**Consequence**: Permanent ban from all community interaction.

## Maintainer Responsibilities

Project maintainers are responsible for:

- Clarifying standards of acceptable behavior
- Taking appropriate corrective action in response to unacceptable behavior
- Removing, editing, or rejecting contributions not aligned with this Code of Conduct
- Communicating reasons for moderation decisions when appropriate

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.1, available at [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html).

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder](https://github.com/mozilla/diversity).

---

## Quick Reference

| Do | Don't |
|----|-------|
| Be kind and respectful | Make personal attacks |
| Give constructive feedback | Be dismissive or condescending |
| Welcome newcomers | Gatekeep or exclude |
| Assume good intentions | Assume malice |
| Focus on the code, not the person | Make it personal |
| Ask clarifying questions | Make assumptions |

---

**Questions about the Code of Conduct?**

Open a discussion on [GitHub Discussions](https://github.com/FinAegis/core-banking-prototype-laravel/discussions) or contact the maintainers privately.
