# Global Currency Unit (GCU) User Guide

## Overview

The Global Currency Unit (GCU) is a revolutionary digital currency that combines the stability of traditional banking with the innovation of user-controlled governance. Your GCU funds are held in real banks with government deposit insurance, while you maintain democratic control over the currency's composition.

## Key Benefits

### 1. **Real Bank Security**
- Funds distributed across 5 regulated banks
- Government deposit insurance (€100k per bank)
- No cryptocurrency risks
- Full regulatory compliance

### 2. **User-Controlled**
- Monthly voting on currency composition
- Your vote weight = your GCU holdings
- Democratic decision-making
- Transparent governance

### 3. **Stable Value**
- Diversified across 6 currencies + gold
- Natural hedge against inflation
- Reduced volatility
- Professional rebalancing

### 4. **Low Fees**
- 0.01% conversion fee
- No hidden charges
- Transparent pricing
- Better than traditional forex

## Getting Started

### Buying Your First GCU

1. **Navigate to GCU Wallet**
   ```
   Dashboard → GCU Wallet → Buy GCU
   ```

2. **Select Source Currency**
   - Choose from your available balances
   - View current exchange rate
   - Check fees (0.01%)

3. **Enter Amount**
   - Minimum: 100 GCU
   - Maximum: Based on verification level
   - See real-time conversion

4. **Review and Confirm**
   - Check conversion details
   - Verify fees
   - Confirm with 2FA

5. **Transaction Complete**
   - Instant conversion
   - GCU added to wallet
   - Receipt available

### Understanding GCU Value

GCU value is calculated based on the weighted average of its components:

**Current Composition (Example)**
```
USD: 35% × $1.00 = $0.35
EUR: 30% × $1.08 = $0.324
GBP: 20% × $1.26 = $0.252
CHF: 10% × $1.12 = $0.112
JPY: 3% × $0.0067 = $0.0002
XAU: 2% × $63.50 = $1.27

Total: 1 GCU = ~$2.31 USD
```

## Bank Allocation

### Setting Your Preferences

1. **Access Bank Preferences**
   ```
   GCU Wallet → Bank Preferences
   ```

2. **Allocate Your Funds**
   
   **Available Banks:**
   - Paysera (Lithuania) - 0-50%
   - Deutsche Bank (Germany) - 0-40%
   - Santander (Spain) - 0-40%
   - Revolut (UK) - 0-30%
   - N26 (Germany) - 0-30%

3. **Rules for Allocation**
   - Must total exactly 100%
   - Respect maximum limits per bank
   - Consider deposit insurance limits
   - Diversify for safety

4. **Select Primary Bank**
   - Used for quick withdrawals
   - Should have highest allocation
   - Can change monthly

### Smart Allocation Strategies

**Conservative (Maximum Protection)**
```
Paysera: 20%
Deutsche Bank: 20%
Santander: 20%
Revolut: 20%
N26: 20%
```
*Benefit: Maximum deposit insurance coverage*

**Balanced (Convenience + Safety)**
```
Paysera: 40% (Primary)
Deutsche Bank: 30%
Santander: 20%
Revolut: 10%
N26: 0%
```
*Benefit: Easy access with good protection*

**Efficient (Minimum Complexity)**
```
Paysera: 50% (Primary)
Deutsche Bank: 30%
Santander: 20%
Revolut: 0%
N26: 0%
```
*Benefit: Simpler management, fewer banks*

## Democratic Voting

### How Voting Works

1. **Monthly Polls**
   - Created on 1st of each month
   - Open for 7 days
   - Results applied on 10th

2. **Voting Power**
   - 1 GCU = 1 vote
   - Snapshot taken at poll creation
   - No minimum required
   - Anonymous voting

3. **What You Vote On**
   - Currency basket composition
   - Emergency rebalancing
   - New currency additions
   - Governance improvements

### Casting Your Vote

1. **Check Active Polls**
   ```
   Governance → Active Polls
   ```

2. **Review Options**
   - Current composition
   - Proposed changes
   - Community discussion
   - Impact analysis

3. **Make Your Choice**
   
   **Example: Monthly Basket Vote**
   ```
   Proposed Allocation:
   □ USD: 35% (current)
   □ EUR: 30% (current)
   □ GBP: 20% (current)
   
   Your Preferred Allocation:
   USD: [32%] ▼
   EUR: [33%] ▲
   GBP: [20%] →
   CHF: [10%] →
   JPY: [3%] →
   XAU: [2%] →
   
   Total: 100% ✓
   ```

4. **Submit Vote**
   - Review your choices
   - Confirm submission
   - Get confirmation receipt
   - Track results

### Understanding Results

**Weighted Average Calculation**
```
Example with 3 voters:
Voter A: 1,000 GCU votes USD=40%
Voter B: 500 GCU votes USD=35%
Voter C: 1,500 GCU votes USD=30%

Result: (1000×40 + 500×35 + 1500×30) / 3000 = 34.17%
```

## Using GCU

### Daily Transactions

1. **Sending GCU**
   - To other FinAegis users: Instant
   - Include payment reference
   - No fees for internal transfers
   - Track in transaction history

2. **Receiving GCU**
   - Automatic credit to wallet
   - Instant notification
   - No action required
   - Full transaction details

3. **Converting GCU**
   - To any supported currency
   - Real-time rates
   - 0.01% fee
   - Instant execution

### Advanced Features

1. **Recurring Conversions**
   - Auto-convert to preferred currency
   - Set thresholds and limits
   - Useful for regular expenses

2. **GCU Baskets**
   - Create custom sub-baskets
   - Different allocation strategies
   - Personal or shared

3. **API Access**
   - Programmatic GCU management
   - Automated trading strategies
   - Webhook notifications

## Risk Management

### Understanding Risks

1. **Currency Risk**
   - Diversification reduces but doesn't eliminate
   - Value can fluctuate with forex markets
   - Protected from single currency crashes

2. **Bank Risk**
   - Mitigated by distribution
   - Deposit insurance protection
   - Regular bank health monitoring

3. **Governance Risk**
   - Democratic decisions may not align with your preferences
   - Monthly changes possible
   - Transparent process

### Protection Strategies

1. **Diversify Holdings**
   - Don't put all assets in GCU
   - Maintain other currency balances
   - Regular portfolio review

2. **Active Participation**
   - Vote in all polls
   - Engage in community discussions
   - Stay informed on changes

3. **Monitor Composition**
   - Track monthly rebalancing
   - Adjust holdings if needed
   - Use alerts for major changes

## Tax Implications

### Important Considerations

1. **Capital Gains**
   - GCU conversions may trigger taxable events
   - Track purchase and sale prices
   - Consult tax advisor

2. **Reporting Requirements**
   - Some jurisdictions require crypto-style reporting
   - Download annual statements
   - Keep detailed records

3. **International Considerations**
   - Cross-border implications
   - Withholding tax possibilities
   - Country-specific rules

## Frequently Asked Questions

### General Questions

**Q: How is GCU different from cryptocurrencies?**
A: In this demo, GCU simulates how funds would be held in banks with deposit insurance. This is a demonstration platform.

**Q: Can I lose money with GCU?**
A: GCU value can fluctuate with currency exchange rates, but diversification reduces volatility compared to single currencies.

**Q: How does the demo simulate bank failures?**
A: The demo shows how funds would theoretically be protected and redistributed in case of bank issues.

### Technical Questions

**Q: How often is GCU value updated?**
A: Every 30 seconds based on real-time exchange rates.

**Q: Can I automate GCU purchases?**
A: Yes, through recurring orders or API integration.

**Q: Is there a GCU debit card?**
A: This is a demo feature showing how debit card integration could work.

### Voting Questions

**Q: What if I miss a vote?**
A: Your voting power isn't used, but you can participate in the next month's vote.

**Q: Can I delegate my votes?**
A: Not currently, but this feature is under consideration.

**Q: How are ties resolved?**
A: The current composition is maintained in case of exact ties.

## Support and Resources

### Getting Help

- **Documentation**: Available in /docs
- **Demo Mode**: Fully functional demonstration
- **Test Accounts**: Pre-configured for testing
- **Source Code**: Available on GitHub

### Stay Updated

- **Demo Features**: All features available for testing
- **API Documentation**: See /docs/04-API
- **Technical Guides**: See /docs/06-DEVELOPMENT
- **Architecture**: See /docs/02-ARCHITECTURE

### Feedback

This is a demonstration platform:
- GitHub Issues: Report bugs and suggestions
- Bug reports: GitHub issues
- General feedback: In-app feedback form

## Conclusion

GCU represents a new paradigm in global finance - combining the security of traditional banking with the innovation of user control. By participating actively in governance and managing your allocations wisely, you can benefit from a truly global, stable, and democratic currency.

Welcome to the future of money. Welcome to GCU.