# Archived Documentation

This directory contains documentation that has been superseded or is preserved for historical reference only. Do not use these documents for current development.

## Archive Contents

### Historical Reference (Retained)
| File/Folder | Purpose | Historical Value |
|-------------|---------|------------------|
| `LITAS_INTEGRATION_ANALYSIS.md` | Litas platform merger analysis | Platform evolution history |
| `GCU_USER_VISION.md` | Original GCU concept | Product vision history |
| `SUBSCRIBER_MANAGEMENT.md` | Newsletter/email system | May contain unique details |
| `PRODUCTION_READINESS_REPORT.md` | Readiness analysis | Reference for future audits |
| `PLATFORM_ANALYSIS_SUMMARY.md` | Platform architecture snapshot | Historical architecture |
| `IMPLEMENTATION_STATUS_2025.md` | v2.0.0 implementation status | Version history |
| `STRATEGIC_PLAN_2025.md` | 2025 development roadmap | Strategic history |
| `litas_specification.pdf` | Litas product specification | Reference document |
| `08-ARCHITECTURE/` | Old architecture docs | Superseded by `02-ARCHITECTURE/` |
| `08-OPERATIONS/` | Old operations docs | Superseded by `10-OPERATIONS/` |
| `deployment/` | Historical deployment guides | Server setup reference |

### Deleted (January 2026 Cleanup)
The following files were removed as they were completed tasks or duplicates:
- TEST-FIX-TODO.md, TEST-FIXES-SUMMARY.md, TEST_SKIP_ANALYSIS.md
- DOCUMENTATION_*.md (various audit reports)
- QUALITY_REPORT.md, WEBSITE_CONTENT_AUDIT.md
- GOOGLE_ANALYTICS_CSP_NOTES.md
- demo-duplicates/, features/ folders

## Current Documentation

For up-to-date information, please refer to:

| Topic | Location |
|-------|----------|
| **Documentation Hub** | [`docs/README.md`](../README.md) |
| **Architecture** | [`docs/02-ARCHITECTURE/`](../02-ARCHITECTURE/) |
| **Features** | [`docs/03-FEATURES/`](../03-FEATURES/) |
| **API Reference** | [`docs/04-API/`](../04-API/) |
| **User Guides** | [`docs/05-USER-GUIDES/`](../05-USER-GUIDES/) |
| **Development** | [`docs/06-DEVELOPMENT/`](../06-DEVELOPMENT/) |
| **Operations** | [`docs/10-OPERATIONS/`](../10-OPERATIONS/) |

## Version History

- **v2.4.0** (February 1, 2026): Current - Privacy & Identity (Key Management, TrustCert)
- **v2.3.0** (February 1, 2026): Industry Leadership (AI, RegTech, BaaS)
- **v2.2.0** (January 31, 2026): Mobile Backend Infrastructure
- **v2.1.0** (January 30, 2026): Security & Enterprise Features
- **v2.0.0** (January 28, 2026): Multi-Tenancy
- **v1.4.x** (January 27, 2026): Test Coverage & Patches

---

*Last Updated: February 1, 2026*
*Cleanup performed for v2.4.0 release*
