<!-- Footer -->
<footer class="bg-gray-900 text-white py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
            <!-- Company -->
            <div>
                <div class="flex items-center mb-4">
                    <span class="text-2xl font-bold text-indigo-400">Fin</span>
                    <span class="text-2xl font-bold text-purple-400">Aegis</span>
                </div>
                <p class="text-gray-400 text-sm">
                    Open-source core banking infrastructure for the next generation of financial services.
                </p>
                <div class="flex space-x-4 mt-4">
                    <a href="#" class="text-gray-400 hover:text-white" aria-label="Facebook">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white" aria-label="Twitter">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white" aria-label="LinkedIn">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                        </svg>
                    </a>
                    <a href="https://github.com/FinAegis/core-banking-prototype-laravel" class="text-gray-400 hover:text-white" aria-label="GitHub">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z"/>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- Product -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Product</h4>
                <ul class="space-y-2">
                    <li><a href="{{ route('platform') }}" class="text-gray-400 hover:text-white">Platform</a></li>
                    <li><a href="{{ route('features') }}" class="text-gray-400 hover:text-white">Features</a></li>
                    <li><a href="{{ route('pricing') }}" class="text-gray-400 hover:text-white">Pricing</a></li>
                    <li><a href="{{ route('cgo') }}" class="text-gray-400 hover:text-white">CGO Investment</a></li>
                    <li><a href="{{ route('security') }}" class="text-gray-400 hover:text-white">Security</a></li>
                    <li><a href="{{ route('compliance') }}" class="text-gray-400 hover:text-white">Compliance</a></li>
                    <li><a href="{{ route('status') }}" class="text-gray-400 hover:text-white">System Status</a></li>
                </ul>
            </div>
            
            <!-- Developers -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Developers</h4>
                <ul class="space-y-2">
                    <li><a href="{{ route('developers') }}" class="text-gray-400 hover:text-white">Developer Hub</a></li>
                    <li><a href="/api/documentation" class="text-gray-400 hover:text-white">API Reference</a></li>
                    <li><a href="{{ route('developers.show', 'sdks') }}" class="text-gray-400 hover:text-white">SDKs</a></li>
                    <li><a href="https://github.com/FinAegis/core-banking-prototype-laravel" class="text-gray-400 hover:text-white">GitHub</a></li>
                    <li><a href="{{ route('developers.show', 'webhooks') }}" class="text-gray-400 hover:text-white">Webhooks</a></li>
                </ul>
            </div>
            
            <!-- Support -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Support</h4>
                <ul class="space-y-2">
                    <li><a href="{{ route('support.contact') }}" class="text-gray-400 hover:text-white">Contact Us</a></li>
                    <li><a href="{{ route('support.faq') }}" class="text-gray-400 hover:text-white">FAQ</a></li>
                    <li><a href="{{ route('support.guides') }}" class="text-gray-400 hover:text-white">User Guides</a></li>
                    <li><a href="{{ route('about') }}" class="text-gray-400 hover:text-white">About Us</a></li>
                    <li><a href="{{ route('blog') }}" class="text-gray-400 hover:text-white">Blog</a></li>
                </ul>
            </div>
        </div>
        
        <div class="border-t border-gray-800 mt-8 pt-8">
            <div class="flex flex-col md:flex-row justify-between items-center">
                <div class="text-gray-400 text-sm mb-4 md:mb-0">
                    © 2026 FinAegis. All rights reserved.
                </div>
                <div class="flex space-x-6">
                    <a href="{{ route('legal.terms') }}" class="text-gray-400 hover:text-white text-sm">Terms of Service</a>
                    <a href="{{ route('legal.privacy') }}" class="text-gray-400 hover:text-white text-sm">Privacy Policy</a>
                    <a href="{{ route('legal.cookies') }}" class="text-gray-400 hover:text-white text-sm">Cookie Policy</a>
                </div>
            </div>
        </div>
    </div>
</footer>