<x-guest-layout>
    <div class="bg-white">
        <!-- Header -->
        <div class="bg-gradient-to-r from-blue-900 to-blue-800">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
                <div class="text-center">
                    <h1 class="text-4xl font-bold text-white sm:text-5xl lg:text-6xl">
                        Our Banking Partners
                    </h1>
                    <p class="mt-6 text-xl text-blue-100 max-w-3xl mx-auto">
                        FinAegis partners with leading financial institutions across Europe to provide you with maximum security and deposit protection.
                    </p>
                </div>
            </div>
        </div>

        <!-- Architecture Notice -->
        <div class="py-8 bg-amber-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white rounded-lg shadow p-6 border-l-4 border-amber-400">
                    <div class="flex items-start">
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-lg font-semibold text-gray-900">Multi-Bank Architecture</h3>
                            <p class="mt-2 text-gray-600">
                                FinAegis supports <strong>multi-bank architecture</strong> with pluggable connectors for institutional partners.
                                The bank integrations shown here are reference implementations demonstrating production integration patterns.
                                Live bank partnerships require separate commercial agreements. Deposit protection figures illustrate
                                the benefit of multi-bank fund distribution.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Partner Banks Section -->
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-gray-900">Trusted Banking Partners</h2>
                <p class="mt-4 text-xl text-gray-600">Your funds are distributed across licensed banks with full deposit insurance</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Paysera -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 text-center">
                    <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-green-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Paysera Bank</h3>
                    <p class="text-gray-600 mb-4">Lithuanian EMI License</p>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>License:</strong> EMI License (EU)</p>
                        <p><strong>Deposit Protection:</strong> €100,000</p>
                        <p><strong>Country:</strong> Lithuania</p>
                        <p><strong>Founded:</strong> 2004</p>
                    </div>
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                            Primary Partner
                        </span>
                    </div>
                </div>

                <!-- Deutsche Bank -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 text-center">
                    <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Deutsche Bank</h3>
                    <p class="text-gray-600 mb-4">German Banking License</p>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>License:</strong> Full Banking License</p>
                        <p><strong>Deposit Protection:</strong> €100,000</p>
                        <p><strong>Country:</strong> Germany</p>
                        <p><strong>Founded:</strong> 1870</p>
                    </div>
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                            Corporate Banking
                        </span>
                    </div>
                </div>

                <!-- Santander -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 text-center">
                    <div class="w-20 h-20 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-red-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Santander Bank</h3>
                    <p class="text-gray-600 mb-4">Spanish Banking License</p>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>License:</strong> Full Banking License</p>
                        <p><strong>Deposit Protection:</strong> €100,000</p>
                        <p><strong>Country:</strong> Spain</p>
                        <p><strong>Founded:</strong> 1857</p>
                    </div>
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                            Retail Banking
                        </span>
                    </div>
                </div>

                <!-- Revolut -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 text-center">
                    <div class="w-20 h-20 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Revolut Bank</h3>
                    <p class="text-gray-600 mb-4">Lithuanian Banking License</p>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>License:</strong> Full Banking License</p>
                        <p><strong>Deposit Protection:</strong> €100,000</p>
                        <p><strong>Country:</strong> Lithuania</p>
                        <p><strong>Founded:</strong> 2015</p>
                    </div>
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                            Digital Banking
                        </span>
                    </div>
                </div>

                <!-- N26 -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 text-center">
                    <div class="w-20 h-20 bg-indigo-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-indigo-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">N26 Bank</h3>
                    <p class="text-gray-600 mb-4">German Banking License</p>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>License:</strong> Full Banking License</p>
                        <p><strong>Deposit Protection:</strong> €100,000</p>
                        <p><strong>Country:</strong> Germany</p>
                        <p><strong>Founded:</strong> 2013</p>
                    </div>
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800">
                            Mobile Banking
                        </span>
                    </div>
                </div>

                <!-- Future Partner Slot -->
                <div class="bg-gray-50 rounded-xl border-2 border-dashed border-gray-300 p-8 text-center">
                    <div class="w-20 h-20 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-500 mb-2">Your Bank Next?</h3>
                    <p class="text-gray-400 mb-4">Partnership Opportunities</p>
                    <p class="text-sm text-gray-500">
                        We're always looking to expand our network of banking partners to provide better coverage and security.
                    </p>
                    <div class="mt-6">
                        <a href="{{ route('support.contact') }}" class="text-blue-600 hover:text-blue-800 font-medium">
                            Partner With Us →
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Benefits Section -->
        <div class="bg-gray-50 py-24">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl font-bold text-gray-900">Why Multi-Bank Distribution?</h2>
                    <p class="mt-4 text-xl text-gray-600">Maximum security through diversification</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-4">Enhanced Security</h3>
                        <p class="text-gray-600">Your funds are never concentrated in a single institution, reducing risk and increasing protection.</p>
                    </div>

                    <div class="text-center">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-4">Higher Insurance Coverage</h3>
                        <p class="text-gray-600">Up to €500,000 total deposit protection across multiple banks, far exceeding single-bank limits.</p>
                    </div>

                    <div class="text-center">
                        <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-4">Improved Uptime</h3>
                        <p class="text-gray-600">If one bank experiences issues, your other accounts remain fully operational, ensuring continuous access.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Regulatory Compliance -->
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-gray-900">Regulatory Compliance</h2>
                <p class="mt-4 text-xl text-gray-600">All our partners maintain the highest regulatory standards</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2L2 7v10c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V7l-10-5z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">EU Licensed</h3>
                    <p class="text-gray-600 text-sm">All partners hold valid EU banking or EMI licenses</p>
                </div>

                <div class="text-center">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">GDPR Compliant</h3>
                    <p class="text-gray-600 text-sm">Full compliance with European data protection regulations</p>
                </div>

                <div class="text-center">
                    <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-yellow-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 1L3 5v6c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V5l-9-4z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">AML/KYC</h3>
                    <p class="text-gray-600 text-sm">Strict anti-money laundering and know-your-customer procedures</p>
                </div>

                <div class="text-center">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 1L3 5v6c0 5.55 3.84 9.74 9 11 5.16-1.26 9-5.45 9-11V5l-9-4z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">PCI DSS</h3>
                    <p class="text-gray-600 text-sm">Payment card industry data security standards compliance</p>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="bg-blue-900 py-16">
            <div class="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
                <h2 class="text-3xl font-bold text-white mb-4">Ready to experience multi-bank security?</h2>
                <p class="text-xl text-blue-100 mb-8">Join FinAegis and benefit from our trusted network of banking partners.</p>
                <a href="{{ route('register') }}" class="bg-white text-blue-900 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition duration-200">
                    Get Started Today
                </a>
            </div>
        </div>
    </div>
</x-guest-layout>